/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * Spreadsheet.java
 *
 * Created on Sep 23, 2010, 7:47:19 PM
 */
package cmsc420project1;

/**
 *
 * @author Jeremiah
 */
public class Spreadsheet extends javax.swing.JFrame
{

    private String[][] expressions;
    private double[][] values;
    // Are we in expression mode or value mode?
    boolean exMode = true;

    /** Creates new form Spreadsheet */
    public Spreadsheet()
    {
        initComponents();
        expressions = new String[10][];
        values = new double[10][];

        for (int x = 0; x < 10; x++)
        {
            expressions[x] = new String[10];
            values[x] = new double[10];
            for (int y = 0; y < 10; y++)
            {
                expressions[x][y] = "";
                values[x][y] = Double.NaN; // Either a calculation messed up, or it is uncalculated.
            }
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        EditButton = new javax.swing.JButton();
        CalcButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                formKeyTyped(evt);
            }
        });

        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {"1", null, null, null, null, null, null, null, null, null, null},
                {"2", null, null, null, null, null, null, null, null, null, null},
                {"3", null, null, null, null, null, null, null, null, null, null},
                {"4", null, null, null, null, null, null, null, null, null, null},
                {"5", null, null, null, null, null, null, null, null, null, null},
                {"6", null, null, null, null, null, null, null, null, null, null},
                {"7", null, null, null, null, null, null, null, null, null, null},
                {"8", null, null, null, null, null, null, null, null, null, null},
                {"9", null, null, null, null, null, null, null, null, null, null},
                {"10", null, null, null, null, null, null, null, null, null, null}
            },
            new String [] {
                "", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.Object.class, java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.String.class
            };
            boolean[] canEdit = new boolean [] {
                false, true, true, true, true, true, true, true, true, true, true
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jTable1.getTableHeader().setReorderingAllowed(false);
        jTable1.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                jTable1PropertyChange(evt);
            }
        });
        jScrollPane1.setViewportView(jTable1);
        jTable1.getColumnModel().getColumn(0).setResizable(false);

        EditButton.setText("Edit");
        EditButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                EditButtonActionPerformed(evt);
            }
        });

        CalcButton.setText("Calculate");
        CalcButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                CalcButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 1079, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(EditButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(CalcButton)))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 191, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(EditButton)
                    .addComponent(CalcButton)))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void formKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_formKeyTyped
        // TODO add your handling code here:
        System.out.println(jTable1.getEditingColumn());
    }//GEN-LAST:event_formKeyTyped

    private void CalcButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_CalcButtonActionPerformed
    {//GEN-HEADEREND:event_CalcButtonActionPerformed
        // Calculate values
        exMode = false;

        // Start by making all values not editable?

        // Reset all values
        for (int x = 0; x < 10; x++)
        {
            for (int y = 0; y < 10; y++)
            {
                // Parse strings and show them.
                values[x][y] = Double.NaN;
            }
        }

        // Put all the values in instead of the equations.
        for (int x = 0; x < 10; x++)
        {
            for (int y = 0; y < 10; y++)
            {
                // Parse strings and show them.
                values[x][y] = parseString(expressions[x][y]);
                jTable1.setValueAt(values[x][y], y, x + 1);
            }
        }

    }//GEN-LAST:event_CalcButtonActionPerformed

    private void EditButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_EditButtonActionPerformed
    {//GEN-HEADEREND:event_EditButtonActionPerformed
        // Revert to equations
        exMode = true;

        for (int x = 0; x < 10; x++)
        {
            for (int y = 0; y < 10; y++)
            {
                jTable1.setValueAt(expressions[x][y], y, x + 1);
            }
        }


    }//GEN-LAST:event_EditButtonActionPerformed

    private void jTable1PropertyChange(java.beans.PropertyChangeEvent evt)//GEN-FIRST:event_jTable1PropertyChange
    {//GEN-HEADEREND:event_jTable1PropertyChange
        // TODO add your handling code here:
        System.out.println("Column: " + jTable1.getEditingColumn());
        System.out.println("Row: " + jTable1.getEditingRow());

        if (jTable1.getEditingColumn() < 0 || jTable1.getEditingRow() < 0)
        {
            return;
        }

        System.out.println("Value: " + jTable1.getValueAt(jTable1.getEditingRow(), jTable1.getEditingColumn()));
        System.out.println();

        // Update expression
        if (exMode == true)
        {
            String expression = (String) jTable1.getValueAt(jTable1.getEditingRow(), jTable1.getEditingColumn());
            if (expression != null)
            {
                expressions[jTable1.getEditingColumn() - 1][jTable1.getEditingRow()] = expression;
            }
        }
    }//GEN-LAST:event_jTable1PropertyChange

    // Parses string and returns a numerical result.
    private Double parseString(String eq)
    {
        FastStack operatorStack = new FastStack();
        FastStack operandStack = new FastStack();
        char[] string = eq.toCharArray();
        if (string.length == 0)
        {
            return 0.0;
        }
        String operand = "";
        if (string[0] == '=')
        {
            // Always add parenthesis around entire expression.
            // Kinda hackish, but works.
            string[0] = '(';
            char[] newExp = new char[string.length + 1];
            System.arraycopy(string, 0, newExp, 0, string.length);
            newExp[newExp.length - 1] = ')';
            string = newExp;

            // Expression
            // Break into symbols

            for (int position = 0; position < string.length; position++)
            {
                if (string[position] != '('
                        && string[position] != ')'
                        && string[position] != '+'
                        && string[position] != '-'
                        && string[position] != '*'
                        && string[position] != '/'
                        && string[position] != '^')
                {   // It is part of a number or cell reference
                    operand = operand + string[position];

                    // If next position is an operator, push it onto operand stack.
                    if (position + 1 == string.length
                            || (string[position + 1] == '('
                            || string[position + 1] == ')'
                            || string[position + 1] == '+'
                            || string[position + 1] == '-'
                            || string[position + 1] == '*'
                            || string[position + 1] == '/'
                            || string[position + 1] == '^'))
                    {
                        operandStack.push(operand);
                        operand = "";
                    }
                } else if (string[position] == '(')
                {
                    operatorStack.push("(");
                } else if (string[position] == ')')
                {
                    // Check for double closed parenthesis
                    if (operatorStack.getSize() > 0)
                    {
                        String op = operatorStack.pop();
                        while (!op.equals("("))
                        {
                            String value2 = operandStack.pop();
                            String value1 = operandStack.pop();
                            double newValue = 0.0;

                            if (op.equals("+"))
                            {
                                newValue = getValue(value1) + getValue(value2);
                            } else if (op.equals("-"))
                            {
                                newValue = getValue(value1) - getValue(value2);
                            } else if (op.equals("*"))
                            {
                                newValue = getValue(value1) * getValue(value2);
                            } else if (op.equals("/"))
                            {
                                newValue = getValue(value1) / getValue(value2);
                            } else if (op.equals("^"))
                            {
                                newValue = Math.pow(getValue(value1), getValue(value2));
                            }

                            operandStack.push(Double.toString(newValue));

                            op = operatorStack.pop();
                        }
                    }
                } else
                {
                    boolean leaveMe = false;
                    while (leaveMe == false)
                    {
                        if (operatorStack.getSize() == 0 || operatorStack.getTop().equals("(") || isHigherPrecedence(operatorStack.getTop(), "" + string[position]))
                        {
                            operatorStack.push("" + string[position]);
                            leaveMe = true;
                        }

                        if (leaveMe != true)
                        {
                            String op = operatorStack.pop();
                            String value2 = operandStack.pop();
                            String value1 = operandStack.pop();
                            double newValue = 0.0;

                            if (op.equals("+"))
                            {
                                newValue = getValue(value1) + getValue(value2);
                            } else if (op.equals("-"))
                            {
                                newValue = getValue(value1) - getValue(value2);
                            } else if (op.equals("*"))
                            {
                                newValue = getValue(value1) * getValue(value2);
                            } else if (op.equals("/"))
                            {
                                newValue = getValue(value1) / getValue(value2);
                            } else if (op.equals("^"))
                            {
                                newValue = Math.pow(getValue(value1), getValue(value2));
                            }

                            operandStack.push(Double.toString(newValue));
//                            leaveMe = true;
                        }
                    }
                }

            }
            if (operandStack.getSize() != 1)
            {
                throw new RuntimeException("Invalid expression.");
            } else
            {
                return getValue(operandStack.pop());
            }
        } else
        {
            // number
            return getValue(eq);
        }
    }

    public boolean isHigherPrecedence(String op1, String op2)
    {
        char op1c = op1.charAt(0);
        char op2c = op2.charAt(0);
        int op1Pres = 0;
        int op2Pres = 0;

        switch (op1c)
        {
            case '+':
            case '-':
                op1Pres = 1;
                break;
            case '*':
            case '/':
                op1Pres = 2;
                break;
            case '^':
                op1Pres = 3;
                break;
            case '(':
            case ')':
                op1Pres = 4;
                break;
        }

        switch (op2c)
        {
            case '+':
            case '-':
                op2Pres = 1;
                break;
            case '*':
            case '/':
                op2Pres = 2;
                break;
            case '^':
                op2Pres = 3;
                break;
            case '(':
            case ')':
                op2Pres = 4;
                break;
        }

        if (op1Pres >= op2Pres)
        {
            return false;
        } else
        {
            return true;
        }

    }

    // Gets value from a number or cell reference.
    // Do NOT try to put expressions in here!
    public double getValue(String operand)
    {
        if (operand == null)
        {
            throw new RuntimeException("NULL!");
        }
        try
        {
            return Double.parseDouble(operand);
        } catch (NumberFormatException e)
        {
            // Java doesn't recognize it at a number - it's a cell reference.
            // The first part should be the letter reference to the cell.
            System.out.println(operand.charAt(0));
            int xPos = operand.charAt(0)-65;
            int yPos = Integer.parseInt(operand.substring(1))-1;

            // See if it has already been calculated.
            if(values[xPos][yPos] != Double.NaN)
            {
                return values[xPos][yPos];
            }

            // Actually he wants it in cell-major order, so if it's not computed
            // yet, it's 0.
            return 0.0;

            // Load the new cell data and parse it.
//            String newValue = expressions[xPos][yPos];
//            return parseString(newValue);
        }
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String args[])
    {
        java.awt.EventQueue.invokeLater(new Runnable()
        {

            public void run()
            {
                new Spreadsheet().setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton CalcButton;
    private javax.swing.JButton EditButton;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTable1;
    // End of variables declaration//GEN-END:variables
}
